# 📱 WISPR FLOW QUICK-REFERENCE CARD
*Print this and keep visible during 10-minute recording*

---

## ⏱️ TIME ALLOCATION

- **Minutes 0-2:** Project Core (WHY it exists)
- **Minutes 2-4:** The Problem (WHAT'S broken)
- **Minutes 4-7:** The Solution (HOW to fix it)
- **Minutes 7-8:** Integrations (WHAT connects)
- **Minutes 8-10:** Edge Cases (WHAT could break)
- **Minutes 10-12:** Success Criteria (WHEN it's done)

---

## 🎤 DICTATION PROMPTS (Say These Out Loud)

### BLOCK 1: Project Core
```
"The project is called _____.

This is for [business/personal/client].

The whole point is _____.

Success means _____.

Timeline is [urgent/normal/exploratory]."
```

### BLOCK 2: The Problem
```
"Right now, [paint the pain].

What's broken is _____.

Without this, _____ happens.

The trigger was _____."
```

### BLOCK 3: The Solution
```
"I want to build _____.

Core features are:
- [Feature 1: user perspective]
- [Feature 2]
- [Feature 3]

Tech stack: [be explicit - Next.js/React/Python]

UI: [Tailwind/Shadcn/specific]

Database: [Postgres/Supabase/file-based/none]

Auth: [Clerk/Auth0/JWT/none]

File structure: [/src/... or organization]"
```

### BLOCK 4: Integrations
```
"Integrates with _____ API.

Credentials are in [.env location / need to create].

API docs at _____.

Error handling should _____."
```

### BLOCK 5: Edge Cases
```
"What if _____ happens?

Must handle [error 1], [error 2], [error 3].

Should NOT _____.

Performance needs: [X users / Y records / Z seconds].

Mobile: [responsive/desktop-only/native]."
```

### BLOCK 6: Success Criteria
```
"Done when:
- [Test 1: specific action + result]
- [Test 2: build/deploy success]
- [Test 3: performance metric]

Quality: [MVP / production / agency].

Testing: [manual / unit tests / integration].

Docs: [README / API docs / tutorial]."
```

---

## 🎯 MAGIC PHRASES FOR CONTEXT

**For Scope:**
- "This is MVP, not production"
- "Just the core workflow, no polish"
- "Agency-deliverable quality"

**For Technical Choices:**
- "Use [exact package] version [X]"
- "Follow [framework] best practices"
- "Don't reinvent - use [library]"

**For File Paths:**
- "Lives at [absolute path]"
- "Add to existing [project-name]"
- "New standalone project"

**For Authentication:**
- "Credentials in .env at [path]"
- "Use existing [API-key/OAuth]"
- "No auth needed"

**For Errors:**
- "Fail gracefully and log"
- "Retry 3x then alert"
- "Show user-friendly message"

**For Data:**
- "Read-only from [source]"
- "Store in [database]"
- "No persistence needed"

---

## ⚠️ ANTI-PATTERNS (Avoid These)

❌ "Something like X"
✅ "Use exactly X package"

❌ "In the project folder"
✅ "At /Users/kinan/project/src/"

❌ "Connect to the API"
✅ "Use Zoho CRM REST v2 at /crm/v2/Leads with API key"

❌ "Make it look good"
✅ "Use Shadcn Card and Table components"

❌ "Handle errors"
✅ "Retry 3x, then show toast with message"

❌ "When done"
✅ "When clicking Submit creates a record and shows success"

---

## ✅ PRE-RECORDING CHECKLIST

- [ ] Project folder path known (absolute)
- [ ] API credentials location known
- [ ] Existing codebase context gathered
- [ ] Example/docs URLs ready to share
- [ ] Mental picture of happy-path workflow
- [ ] List of 3-5 edge cases
- [ ] Concrete success test in mind

---

## 🔑 POWER TIPS

**Talk like you're explaining to a smart friend, not writing formal docs.**

**Use "I" and "user" perspective:**
- ✅ "I want to click Add Task and see it appear"
- ❌ "The system shall implement task addition"

**Reference past patterns:**
- "Like we did in [previous-project]"
- "Similar to [known-app]"
- "The standard [framework] approach"

**Call out constraints clearly:**
- "Budget is $X"
- "Timeline is Y hours"
- "Can't use Z library"

**Be specific about outcomes:**
- ✅ "Loads in under 2 seconds"
- ❌ "Fast performance"

---

## 💡 PRO MOVE: TWO-PASS RECORDING

**Pass 1 (5 min):** Brain dump - say everything that comes to mind

**Pass 2 (10 min):** Structured - follow this template methodically

*Use both transcripts together for maximum context*

---

## 🤝 AFTER RECORDING

Paste transcript into Claude and say:

> "I've dictated a PRD using Wispr Flow. Process this using the Ralph Voice PRD System. Ask me clarifying questions one at a time, starting with blockers. After Q&A, generate the /ralph-loop command."

Then answer 5-10 questions and you're done!

---

**💾 SAVE THIS FILE: `/path/to/Wispr_Flow_Cheatsheet.md`**

*Keep open on second monitor or print for recording sessions*
