# Voice-Optimized PRD Template for Genesis/Claude Code
*Designed for Wispr Flow dictation - speak naturally for ~10 minutes per project*

## Phase 1: VOICE CAPTURE (Your Part - ~10 min dictation)

### Start Recording and Speak Through These Prompts:

**PROJECT IDENTITY**
- "The project name is..."
- "This is for..." (business/personal/client)
- "The main reason this exists is..."
- "Success looks like..."

**THE PROBLEM & CONTEXT**
- "The current situation is..."
- "The pain point we're solving is..."
- "Without this, what happens is..."
- "Users/stakeholders are currently..."

**THE SOLUTION (High Level)**
- "What we're building is..."
- "The core features are..."
- "Users will be able to..."
- "The expected workflow is..."

**TECHNICAL LANDSCAPE**
- "The stack/frameworks I want are..."
- "Existing codebase context..." (if applicable)
- "Integration points are..."
- "Dependencies include..."
- "File structure should be..."

**EDGE CASES & CONSTRAINTS**
- "What happens when..."
- "We need to handle..."
- "It should NOT do..."
- "Performance requirements..."
- "Scale considerations..."

**USER INTERACTIONS**
- "The main user journey is..."
- "Error scenarios look like..."
- "Mobile/desktop considerations..."
- "Authentication/permissions..."

**SUCCESS METRICS**
- "We know it's done when..."
- "Testing criteria include..."
- "Quality bars are..."

---

## Phase 2: CLARIFICATION QUESTIONS (Claude's Part)

*Claude will systematically extract these from your voice capture and ask what's missing*

### ARCHITECTURAL CLARITY
```
1. Repository Structure
   - Where does this code live?
   - New repo or existing? If existing, which path?
   - What's the file/folder naming convention?

2. Dependencies & Environment
   - Package manager? (npm, pip, etc.)
   - Environment variables needed?
   - API keys/credentials required?
   - Database connections?

3. External Integrations
   - Third-party services?
   - API endpoints to consume?
   - Webhooks to configure?
```

### IMPLEMENTATION SPECIFICS
```
4. Data Flow
   - Where does data come from?
   - Where does it go?
   - What's the transformation logic?
   - Caching strategy?

5. UI/UX Details (if applicable)
   - Component library? (Shadcn, etc.)
   - Styling approach? (Tailwind, CSS modules, etc.)
   - Responsive breakpoints?
   - Accessibility requirements?

6. Error Handling
   - What happens on failure?
   - Retry logic?
   - User feedback mechanisms?
   - Logging strategy?
```

### OPERATIONAL REQUIREMENTS
```
7. Testing Strategy
   - Unit tests required?
   - Integration test scenarios?
   - Manual testing checklist?

8. Documentation
   - README updates needed?
   - API docs required?
   - Comments level expected?

9. Deployment
   - How will this be deployed?
   - Build steps?
   - Environment-specific configs?
```

### CRITICAL GAPS
```
10. Assumptions Check
    - "You mentioned X, but didn't specify Y. Should I assume...?"
    
11. Scope Boundaries
    - "Is [feature] in scope for this PRD or future?"
    
12. Priority Order
    - "If these conflict, which takes priority: performance vs features vs timeline?"
```

---

## Phase 3: AGENT-READY OUTPUT FORMAT

*Claude transforms the above into this structure for Genesis/Claude Code*

```json
{
  "project": {
    "name": "string",
    "type": "new|enhancement",
    "businessContext": "string",
    "primaryGoal": "string"
  },
  
  "technicalSpec": {
    "targetPath": "string",
    "stack": ["array of technologies"],
    "dependencies": {
      "required": ["must-haves"],
      "optional": ["nice-to-haves"]
    },
    "environment": {
      "variables": ["ENV_VAR_NAME"],
      "credentials": ["SERVICE_API_KEY"]
    }
  },
  
  "userStories": [
    {
      "id": "US-001",
      "title": "Brief user story",
      "description": "As a [user], I want [goal] so that [benefit]",
      "acceptanceCriteria": [
        "GIVEN [context] WHEN [action] THEN [result]",
        "AND [additional criteria]"
      ],
      "technicalNotes": "Implementation hints",
      "estimatedComplexity": "simple|medium|complex",
      "dependencies": ["US-002"],
      "fileTargets": ["/path/to/file.ts"]
    }
  ],
  
  "dataFlow": {
    "inputs": ["description of data sources"],
    "transformations": ["what happens to data"],
    "outputs": ["where data goes"],
    "storage": "persistence strategy"
  },
  
  "errorHandling": {
    "scenarios": [
      {
        "condition": "what could go wrong",
        "response": "how to handle it",
        "userFeedback": "what user sees"
      }
    ],
    "logging": "strategy description"
  },
  
  "testing": {
    "unitTests": ["test scenarios"],
    "integrationTests": ["end-to-end flows"],
    "manualChecklist": ["human verification steps"]
  },
  
  "successCriteria": {
    "functional": ["feature works as described"],
    "technical": ["no linter errors", "builds successfully"],
    "quality": ["performance benchmarks", "code standards"],
    "documentation": ["README updated", "comments added"]
  },
  
  "constraints": {
    "mustNot": ["things to avoid"],
    "performance": ["response time", "memory limits"],
    "scale": ["concurrent users", "data volume"]
  },
  
  "safetyLimits": {
    "maxIterations": 30,
    "timeoutWarning": "human review needed if exceeds X hours"
  }
}
```

---

## USAGE WORKFLOW

### Step 1: Dictate (You)
```
1. Open Wispr Flow
2. Start recording
3. Talk through Phase 1 prompts naturally for ~10 minutes
4. Don't overthink - just brain dump everything
5. Stop recording
```

### Step 2: Initial Processing (Claude)
```
Paste your voice transcription and say:

"Use the Voice-Optimized PRD Template. Parse my voice capture, 
extract all details into the structured format, then ask me 
ONLY the clarifying questions where information is missing or ambiguous."
```

### Step 3: Rapid-Fire Q&A (You + Claude)
```
Claude asks targeted questions one by one.
You answer briefly - voice or text.
Claude updates the PRD in real-time.
```

### Step 4: Final PRD Review (Claude)
```
Claude presents:
- Complete agent-ready JSON
- Summary of user stories
- Dependency graph
- Risk flags

You review and approve or iterate.
```

### Step 5: Handoff to Genesis/Claude Code
```
Claude generates:
/ralph-loop command with PRD
OR
Direct Genesis execution instructions
```

---

## ANTI-PATTERNS TO AVOID

**❌ Don't dictate like you're writing**
- Avoid: "The system shall implement a RESTful API..."
- Do: "We need an API that handles GET and POST requests for user data..."

**❌ Don't skip edge cases**
- Avoid: Assuming happy path only
- Do: "What if user has no internet? What if API is down?"

**❌ Don't say "something like X"**
- Avoid: "Use something like Tailwind or whatever"
- Do: "Use Tailwind for styling, specifically version 3.x"

**❌ Don't leave authentication vague**
- Avoid: "Handle login somehow"
- Do: "OAuth with Google, store JWT in httpOnly cookie"

---

## POWER TIPS FOR ONE-SHOT EXCELLENCE

### During Dictation:
1. **Start with "Why" not "What"** - Context drives better requirements
2. **Use user perspective** - "A user clicks X and sees Y"
3. **Say constraints out loud** - "We can't use package Z because..."
4. **Mention failure modes** - "If this fails, then..."
5. **Reference existing patterns** - "Like we did in project Y..."

### For Claude's Questions:
1. **Prioritize by risk** - Ask about integration points first
2. **Group related questions** - Bundle auth questions together
3. **Provide context with questions** - "You mentioned API but didn't specify..."
4. **Offer smart defaults** - "Should I assume REST unless you say GraphQL?"
5. **Confirm scope boundaries** - "Is X in this PRD or separate?"

### For Agent Handoff:
1. **Include "agents.md" context** - Long-term learnings
2. **Set realistic iteration caps** - Complex features need 20-30 iterations
3. **Define "done" clearly** - Checklist not feelings
4. **Specify file targets** - Don't make agent guess where code goes
5. **Add escape hatches** - "If you can't solve X in 3 iterations, flag for human"

---

## EXAMPLE VOICE DICTATION (GOOD)

*"Okay so the project name is AgileAdapt Client Dashboard. This is for my AI automation business targeting Australian tradies. The main reason this exists is I need a way for clients to view their chatbot analytics and manage their AI voice agent settings without calling me every time.*

*The current situation is I'm manually sending screenshots of analytics from multiple platforms and it's taking hours per week. The pain point is clients can't self-serve and I'm becoming a bottleneck.*

*What we're building is a Next.js dashboard, using Tailwind and Shadcn UI components, that pulls data from Stammer AI's API and 10web analytics. Users will be able to log in with their email, see call volume charts, chatbot conversation counts, and toggle voice agent hours.*

*The stack is Next.js 14 app router, TypeScript, Tailwind, Shadcn, and we'll use Supabase for auth and storing user preferences. The existing codebase is at github.com/AgileAdapt/client-portal. Integration points are Stammer AI REST API and 10web webhooks.*

*What happens when Stammer API is down? Show cached data with a warning banner. We need to handle rate limiting from 10web - max 100 requests per hour so we'll cache for 15 minutes. It should NOT allow users to modify pricing plans - that's admin only. Performance requirement is dashboard loads under 2 seconds.*

*The main user journey is: user gets email invite with magic link, clicks it, sees dashboard immediately with their three clients (if they're an agency) or their single business (if they're a sole tradie). They can switch between clients with a dropdown. Error scenarios - if API returns 401, log them out and show re-auth button.*

*We know it's done when: user can log in, see real data from both APIs, switch clients if multi-client, and their toggled settings persist and actually update the voice agent hours in Stammer. Testing criteria include manual login test, API mock tests for failure scenarios, and visual regression test for the charts.*

*Also need to handle mobile - should work on iPhone since tradies use phones a lot. Use Shadcn's responsive variants. Authentication needs rate limiting on magic link sends - max 3 per hour per email to prevent abuse. The dashboard should auto-refresh data every 5 minutes without page reload. And create an agents.md file in the /dashboard folder explaining the API integration patterns for future features."*

---

## EXAMPLE CLARIFICATION Q&A (GOOD)

**Claude:** "You mentioned Stammer AI REST API but didn't specify authentication. What auth method does Stammer use? Do you have API keys?"

**You:** "Yeah Stammer uses API key in header as Bearer token. I have keys in my password manager."

**Claude:** "Got it. Should I set up environment variables for staging and production keys separately?"

**You:** "Yes - STAMMER_API_KEY_STAGING and STAMMER_API_KEY_PROD."

**Claude:** "You mentioned 'three clients if agency' - where does this client list come from? Supabase table?"

**You:** "Yes, there's a 'clients' table that links to the user. Schema is user_id, client_id, client_name, stammer_bot_id, tenWeb_site_id."

**Claude:** "Perfect. For the magic link email, should I build that or use a service?"

**You:** "Use Resend for emails. I have an account and API key."

**Claude:** "Clear. Last question - you said 'toggle voice agent hours' but what's the actual interface? Dropdown? Time picker?"

**You:** "Time range picker - start time and end time in client's local timezone. Restrict to business hours 6am-10pm."

---

## SUCCESS METRICS FOR THIS TEMPLATE

You'll know this template is working when:

✅ Claude asks fewer than 10 clarifying questions
✅ Zero "wait, you didn't tell me X" during development  
✅ Agent completes >80% of user stories without human intervention
✅ First iteration produces runnable code
✅ You can dictate a new PRD in under 15 minutes
✅ Clarification Q&A takes under 10 minutes
✅ No scope creep during implementation

---

## NEXT: Save Your Best PRDs as Examples

After you've used this template 3-4 times, save your best voice dictation + final PRD pairs. Use them as few-shot examples when starting new projects:

"Here's how I previously dictated the ClientDashboard PRD [paste example]. Now I want to dictate a new project for [X]..."

This trains Claude to understand YOUR communication style and business context, making each subsequent PRD even better.
