# WISPR FLOW DICTATION GUIDE - Quick Reference
*Keep this visible while recording. Speak naturally through each prompt.*

---

## 🎙️ THE 10-MINUTE DICTATION STRUCTURE

### 1. PROJECT IDENTITY (1 min)
→ Name and why it exists
→ Success definition

### 2. THE PROBLEM (2 min)  
→ Current painful situation
→ What breaks without this

### 3. THE SOLUTION (3 min)
→ What you're building
→ Core features and workflow
→ Stack and frameworks

### 4. TECHNICAL CONTEXT (2 min)
→ Where code lives
→ Integration points
→ Dependencies

### 5. EDGE CASES (1 min)
→ "What happens when..."
→ Failure modes
→ Constraints

### 6. SUCCESS CRITERIA (1 min)
→ "We know it's done when..."
→ Testing checklist

---

## 🎯 MAGIC PHRASES TO USE

**For context:** "The reason this exists is..."

**For technical:** "The stack is... using..."

**For scope:** "It should... but it should NOT..."

**For failure:** "What happens when... is..."

**For success:** "We know it's done when..."

**For integration:** "This connects to... via..."

**For users:** "A user will... and see..."

**For constraints:** "We can't... because..."

---

## ✅ ANTI-PATTERNS TO AVOID

❌ "Something like..."  
✅ "Specifically using..."

❌ "Handle login"  
✅ "OAuth with Google, JWT in httpOnly cookie"

❌ "Make it responsive"  
✅ "Mobile-first with Tailwind breakpoints, works on iPhone"

❌ "Use an API"  
✅ "REST API with Bearer token auth, rate limit 100/hour"

---

## 🔥 POWER MOVES

**Start with WHY before WHAT**  
"This exists because tradies are calling me daily..." → Better context

**Speak in user perspective**  
"User clicks send, sees loading spinner, gets success toast..."

**Name your APIs explicitly**  
"Stammer AI API", "10web webhooks", "Supabase auth"

**Call out the negatives**  
"Should NOT allow pricing changes" - prevents scope creep

**Reference existing patterns**  
"Like we did in ClientDashboard..." - reuse good decisions

---

## 📋 QUICK CHECKLIST BEFORE YOU START

- [ ] Project name decided?
- [ ] You know what stack/frameworks?
- [ ] Clear on where code lives?
- [ ] Identified integration points?
- [ ] Thought through one failure scenario?
- [ ] Defined what "done" looks like?

**If you checked 5+ boxes, START RECORDING.**  
If not, think for 2 more minutes then record anyway - Claude will ask about gaps.

---

## 🎬 EXAMPLE OPENING (COPY THIS PATTERN)

*"Okay, project name is [X]. This is for [business/personal/client]. The main reason this exists is [core problem]. Success looks like [concrete outcome].*

*The current situation is [painful reality]. Without this, what happens is [bad consequence].*

*What we're building is [solution description] using [stack]. Users will be able to [key actions].*

*The technical setup is [frameworks], code lives at [path/repo], integrates with [services] via [method].*

*What happens when [failure case] is [handling strategy]. We can't [constraint] because [reason].*

*We know it's done when [success criteria 1], [success criteria 2], and [testing passes]."*

---

## 🚀 AFTER RECORDING

**Paste transcript and say:**

*"Use the Voice-Optimized PRD Template. Parse this, extract into structured format, then ask ONLY the clarifying questions for missing/ambiguous details."*

Claude will ask ~5-10 targeted questions. Answer briefly. PRD gets built in real-time.

---

## 💡 PRO TIP

Record TWO passes if complex:
1. **Brain dump** (5-7 min) - Get it all out messily
2. **Structured pass** (8-10 min) - Follow this guide after reviewing brain dump

This catches more edge cases and produces better PRDs.
