# RALPH VOICE PRD SYSTEM
*10-Minute Voice → Autonomous Agent Execution*

**Purpose:** Transform Wispr Flow dictation into Ralph Wiggum loops or Genesis Protocol executions with ZERO gaps in agent understanding.

---

## 🎯 THE PHILOSOPHY

You're **absolutely correct** that clarifying questions are the critical success factor. An autonomous agent executing overnight will:
- ❌ Make wrong assumptions when requirements are unclear
- ❌ Implement the wrong thing and burn tokens
- ❌ Get stuck on blockers you could have clarified in 30 seconds
- ✅ Execute perfectly when requirements are complete and unambiguous

**This system prioritizes thoroughness over speed.**

---

## 📋 PART 1: WISPR FLOW DICTATION SCRIPT

### Before You Press Record:

**Have Ready:**
- Project folder path (absolute path)
- Any API keys/credentials you know about
- Links to any docs/examples you want referenced
- Existing codebase context if adding to existing project

### Recording Structure (Natural Speech, ~10-12 minutes):

#### BLOCK 1: PROJECT CORE (2 min)
```
"The project is called [NAME].

This is for [business/personal/AgileAdapt/RiverSun/Genesis].

The whole point of this is [explain the WHY - the business value or problem].

Success means [concrete outcome - revenue, users, automation achieved].

The timeline is [urgent/normal/exploratory]."
```

#### BLOCK 2: THE PROBLEM (2 min)
```
"Right now, [describe current pain state in detail].

What's broken is [specific failure mode].

The manual process today involves [step by step].

Without this, [consequence - time lost, money lost, opportunity missed].

The trigger for needing this is [recent event or realization]."
```

#### BLOCK 3: THE SOLUTION (3 min)
```
"What I want to build is [describe at high level].

The core features are:
- [Feature 1 - user perspective: 'user can click X and see Y']
- [Feature 2]
- [Feature 3]
- [Feature 4]

The main user workflow is [walk through the happy path].

For tech stack, I want to use [be explicit - Next.js, React, Python, Node, etc.].

For UI, use [Tailwind/Shadcn/Material/specific components].

For database, [Postgres/Supabase/MongoDB/file-based/none].

For authentication, [Clerk/Auth0/JWT/none].

The file structure should [live in /src/... or be organized as...]."
```

#### BLOCK 4: INTEGRATION POINTS (1 min)
```
"This needs to integrate with [API/service name].

The credentials are [stored in .env / in Zoho / need to be created].

For API docs, check [specific URL or 'standard REST docs'].

Rate limits are [if known].

Error handling for these APIs should [fail gracefully / retry / alert]."
```

#### BLOCK 5: EDGE CASES & CONSTRAINTS (2 min)
```
"What happens when [user does unexpected thing]?

We need to handle [error scenario 1, 2, 3].

It should NOT [anti-feature - what it should never do].

Performance-wise, it needs to [handle X users / process Y records / respond in Z seconds].

For mobile, [must be responsive / desktop only / native-feel required].

The critical constraint is [budget/time/API limits/data privacy]."
```

#### BLOCK 6: SUCCESS CRITERIA (1 min)
```
"I know it's done when:
- [Concrete test 1: 'I can click Add Task and see it in the Todo column']
- [Concrete test 2: 'Running npm run build shows zero errors']
- [Concrete test 3: 'The API returns data within 2 seconds']

The quality bar is [MVP rough / production-ready / agency-deliverable].

For testing, [manual only / unit tests required / integration tests needed].

Documentation should be [README only / full API docs / tutorial included]."
```

---

## 🤖 PART 2: CLAUDE'S CLARIFICATION PROTOCOL

*This is for Claude to follow when processing your voice transcript*

### STEP 1: INITIAL TRIAGE (Silent Processing)

Parse transcript into buckets:

```yaml
DECLARED:
  - Explicit technical choices
  - Named services/APIs
  - Concrete constraints
  - Specified file paths
  
IMPLIED:
  - Standard patterns for this stack
  - Common defaults (e.g., "Next.js" implies "React")
  - Industry best practices
  
MISSING_BLOCKERS:
  - File system locations
  - Auth mechanisms
  - Credential sources
  - Database schemas
  - Environment setup steps
  
MISSING_DETAILS:
  - Error handling specifics
  - UI/UX polish details
  - Testing approach
  - Deployment strategy
  
AMBIGUOUS:
  - Contradictory statements
  - Vague scope ("something like X")
  - Unclear dependencies
  
RISKS:
  - Complex integrations without details
  - Performance requirements without benchmarks
  - Scope creep indicators
```

### STEP 2: SMART DEFAULTS DECLARATION

Before asking questions, **declare your intelligent defaults** based on the stack:

```
"Based on your stack choice of [X], I'm planning to use these defaults:
- Testing: [Vitest/Jest/pytest] 
- Error handling: [try/catch with logging / error boundaries]
- State management: [Context API / Redux / Zustand]
- API client: [fetch / axios / specific SDK]

I'll proceed with these unless you need something different."
```

### STEP 3: DEPENDENCY-ORDERED QUESTIONS

**Critical Rule: ASK ONE QUESTION AT A TIME. WAIT FOR ANSWER. THEN ASK NEXT.**

#### QUESTION PRIORITY TIERS:

**🔴 TIER 0 - ABSOLUTE BLOCKERS (Ask First, One at a Time)**

Template:
```
"For [specific feature], I need to know [concrete detail] because [reason].

Options:
A) [Smart default based on transcript clues]
B) [Alternative 1]
C) [Alternative 2]

Which approach, or should I use [suggest smart default]?"
```

Examples:
```
❌ BAD: "Where should files go?"
✅ GOOD: "You mentioned this adds to an existing project. What's the absolute path to the project root? (e.g., /Users/kinan/projects/agileadapt or E:\genesis-system)"

❌ BAD: "How should auth work?"
✅ GOOD: "For the Zoho CRM integration, are the API credentials:
A) Already in a .env file (tell me the path)
B) In Zoho admin panel (I'll add .env instructions)
C) Need to be generated first

I'm guessing A since you mentioned existing integration."

❌ BAD: "What about the database?"
✅ GOOD: "For storing tradie leads, I heard you mention Zoho CRM. Should I:
A) Pull data from Zoho CRM API (read-only)
B) Use a local Postgres database synced from Zoho
C) Store everything in Zoho directly

I'm leaning towards A based on your description."
```

**🟡 TIER 1 - IMPLEMENTATION DETAILS (Ask After Blockers)**

```
"For [feature X], when [error scenario] happens, should I:
A) [Conservative approach]
B) [User-friendly approach]  
C) [Fail-fast approach]

Given your mention of [transcript clue], I'd suggest [A]."
```

**🟢 TIER 2 - POLISH & PREFERENCES (Propose, Don't Ask)**

```
"For [non-critical aspect], I'll use [sensible default] unless you object."
```

### STEP 4: QUESTION PATTERNS LIBRARY

Use these proven patterns:

#### For File System Issues:
```
"You mentioned [feature]. Should these files go in:
- [Existing path from context]/[logical-subfolder]
- Create new folder at [suggested-path]
- Other location?

Based on [clue from transcript], I'm planning: [suggest specific path]"
```

#### For Authentication:
```
"For [integration/feature], I need credentials. Are they:
- Already in .env at [guessed-path]
- In [service] admin panel (I'll document how to get them)
- Generated via [API/OAuth flow]

You mentioned [context-clue], so I'm guessing: [specific answer]"
```

#### For Error Handling:
```
"When [API/operation] fails, should I:
A) Show user-friendly error and log to console
B) Retry [N] times then fail gracefully
C) Alert via [mechanism] and halt operation

For [user-type], I'd suggest [A]."
```

#### For Scope Boundaries:
```
"You mentioned [feature-group]. For MVP, should I:
- Just core functionality: [list 2-3 items]
- Add nice-to-haves: [list 2-3 items]

I heard urgency in your tone, so I'm planning just core."
```

#### For Data Flow:
```
"For [workflow], the data flow is:
[User action] → [Process 1] → [Process 2] → [Outcome]

Does this match your mental model, or should [step X] happen differently?"
```

### STEP 5: PROGRESSIVE QUESTIONING STRATEGY

**Round 1 (Blockers):** Ask 2-3 critical questions about paths, auth, and environment.

**Wait for user response.**

**Round 2 (Implementation):** Based on answers, ask 2-3 questions about error handling, data flow, or integration details.

**Wait for user response.**

**Round 3 (Confirmation):** Present structured summary with your smart defaults filled in. Ask: "Does this capture it accurately?"

**Total question count target: 5-10 questions maximum**

---

## 📊 PART 3: THE AGENT-READY OUTPUT FORMATS

### FORMAT A: For Ralph Wiggum Loop (/ralph-loop)

```markdown
/ralph-loop

### PROJECT: [Name from transcript]

### CONTEXT:
[2-3 sentence summary of WHY this exists and WHO it's for]

### REQUIREMENTS:
* [Requirement 1 - atomic, testable]
* [Requirement 2 - includes specific tech choice]
* [Requirement 3 - references file paths]
* [Requirement 4 - specifies integration details]
* [Each requirement is a complete thought, no ambiguity]

### SUCCESS CRITERIA:
* [Criterion 1 - concrete test: "Clicking X results in Y"]
* [Criterion 2 - measurable: "Build command succeeds with 0 errors"]
* [Criterion 3 - integration proof: "API returns data in <2sec"]
* [Criterion 4 - visual confirmation: "Dashboard shows live data"]
* Zero linter errors and [npm run build / pytest / cargo build] succeeds
* [Framework]-specific: All [tests/type checks/formatting] pass
* Documentation updated: README shows [how to run/key features]

### TECHNICAL CONSTRAINTS:
* Stack: [Exact framework versions]
* File locations: [Absolute paths specified]
* Credentials: [Location of .env or secrets]
* APIs: [Exact endpoints and auth methods]
* Performance: [Specific metrics if mentioned]

### USER STORIES (Atomic Units):

#### Story 1: [Setup / Infrastructure]
**Title:** [e.g., "Initialize Next.js project with Tailwind"]
**Description:** As a developer, I need [outcome] so that [reason]
**Acceptance Criteria:**
- [ ] [Specific file exists at path]
- [ ] [Configuration loads without errors]
- [ ] [Command `npm run dev` starts server]

**Files to modify/create:**
- `/path/to/project/package.json`
- `/path/to/project/tailwind.config.js`

**Dependencies:**
- None (first story)

---

#### Story 2: [Core Feature - Atomic]
**Title:** [e.g., "Add task creation form to UI"]
**Description:** As a user, I want to [action] so that [outcome]
**Acceptance Criteria:**
- [ ] GIVEN I'm on dashboard page
- [ ] WHEN I click "Add Task" button
- [ ] THEN modal appears with form fields [name, due date, priority]
- [ ] AND form validates required fields
- [ ] AND successful submission shows new task in list

**Files to modify/create:**
- `/src/components/TaskForm.tsx`
- `/src/app/dashboard/page.tsx`

**Dependencies:**
- Story 1 complete

---

[Continue for N user stories - each completable in ONE iteration]

### SAFETY LIMITS:
* Max Iterations: 30
* Timeout per iteration: 10 minutes
* Token budget: $30 estimated

### ERROR HANDLING STRATEGY:
* [Specific approach from clarification Q&A]
* Log errors to [location]
* User-facing errors should [behavior]
* API failures should [retry strategy]

### TESTING APPROACH:
* [Manual / Unit tests / Integration tests]
* Test files location: [path]
* Run tests via: [command]
```

### FORMAT B: For Genesis Protocol Execution

```json
{
  "project_id": "[name-kebab-case]",
  "genesis_mode": "autonomous",
  "priority": "high|normal|low",
  
  "context": {
    "business_unit": "AgileAdapt|RiverSun|Genesis|Personal",
    "problem_statement": "[2 sentences max]",
    "success_outcome": "[Concrete result]"
  },
  
  "environment": {
    "base_path": "[absolute-path]",
    "credentials_location": "[.env path or other]",
    "existing_codebase": true|false,
    "repository_url": "[if applicable]"
  },
  
  "technical_spec": {
    "stack": {
      "framework": "[Next.js|React|Python|etc]",
      "language_version": "[specific]",
      "database": "[Postgres|Supabase|none]",
      "auth": "[Clerk|Auth0|JWT|none]"
    },
    "dependencies": [
      "package-name@version",
      "another-package@version"
    ],
    "integrations": [
      {
        "service": "[Zoho CRM|Stammer AI|etc]",
        "auth_type": "[API-key|OAuth|JWT]",
        "credentials_ref": "$ZOHO_API_KEY",
        "docs_url": "[if available]"
      }
    ]
  },
  
  "user_stories": [
    {
      "id": "US-001",
      "title": "[Short title]",
      "description": "As a [user-type], I want to [action] so that [outcome]",
      "acceptance_criteria": [
        "GIVEN [context]",
        "WHEN [action]",
        "THEN [expected-result]"
      ],
      "files_affected": [
        "/absolute/path/to/file1.tsx",
        "/absolute/path/to/file2.py"
      ],
      "dependencies": [],
      "story_points": 3,
      "iteration_estimate": 1
    }
  ],
  
  "data_flow": {
    "inputs": [
      {
        "source": "[User input|API|Database]",
        "format": "[JSON|form-data|etc]",
        "validation": "[rules]"
      }
    ],
    "processing": [
      {
        "step": "[Transform data]",
        "library": "[if applicable]",
        "error_handling": "[strategy]"
      }
    ],
    "outputs": [
      {
        "destination": "[UI|Database|API]",
        "format": "[JSON|HTML|etc]"
      }
    ]
  },
  
  "error_handling": {
    "strategy": "graceful|fail-fast|retry",
    "logging": {
      "location": "/path/to/logs",
      "level": "info|debug|error"
    },
    "user_feedback": "toast|modal|inline",
    "api_failures": {
      "retry_count": 3,
      "backoff": "exponential",
      "fallback": "[behavior]"
    }
  },
  
  "testing_requirements": {
    "type": "manual|unit|integration|e2e",
    "framework": "[Vitest|Jest|pytest]",
    "coverage_target": 80,
    "critical_paths": [
      "[User login flow]",
      "[Data submission]",
      "[API integration]"
    ]
  },
  
  "success_criteria": [
    {
      "criterion": "[Specific test]",
      "test_method": "manual|automated",
      "passing_condition": "[Exact expectation]"
    }
  ],
  
  "constraints": {
    "budget": "$30 tokens max",
    "timeline": "24h|1week|exploratory",
    "scope_boundaries": [
      "Include: [features]",
      "Exclude: [anti-features]"
    ]
  }
}
```

---

## 🎬 PART 4: THE COMPLETE WORKFLOW

### User's Steps:

1. **Pre-flight** (5 min)
   - Gather file paths, API keys location, codebase context
   - Review dictation script prompts
   - Start Wispr Flow

2. **Voice Capture** (10-12 min)
   - Follow dictation script naturally
   - Don't edit yourself - just talk through it
   - Cover all 6 blocks

3. **Paste & Engage** (1 min)
   - Paste transcript into Claude
   - Say: "I've dictated a PRD. Use the Ralph Voice PRD System to process this. Ask me clarifying questions one at a time."

4. **Clarification Q&A** (5-10 min)
   - Answer Claude's questions
   - Claude asks 5-10 targeted questions
   - Confirm the final structured summary

5. **Generation** (1 min)
   - Claude outputs /ralph-loop command OR Genesis JSON
   - You copy and execute

### Claude's Steps:

1. **Parse transcript** into DECLARED / IMPLIED / MISSING / RISKS buckets

2. **Declare smart defaults** based on stack and context

3. **Ask BLOCKER questions first** (one at a time)
   - File paths
   - Credentials
   - Environment setup

4. **Ask IMPLEMENTATION questions second** (one at a time)
   - Error handling
   - Data flow
   - Integration specifics

5. **Present STRUCTURED SUMMARY** with all defaults filled in
   - User confirms or corrects

6. **Generate FINAL OUTPUT** in chosen format
   - Ralph Wiggum loop
   - Genesis Protocol JSON
   - Hybrid approach

---

## ⚡ ANTI-PATTERNS & FIXES

### ❌ What NOT to Do:

**Anti-Pattern: Vague Success Criteria**
```
❌ "The app should work well"
✅ "Clicking 'Submit' creates a record in Zoho CRM within 3 seconds and shows success toast"
```

**Anti-Pattern: Missing File Paths**
```
❌ "Add this to the project"
✅ "Add TaskForm.tsx to /Users/kinan/agileadapt/src/components/"
```

**Anti-Pattern: Ambiguous Integrations**
```
❌ "Connect to Zoho"
✅ "Use Zoho CRM REST API v2 with API key from .env.local ($ZOHO_API_KEY) to fetch leads from /crm/v2/Leads endpoint"
```

**Anti-Pattern: Open-Ended Questions**
```
❌ "What features do you want?"
✅ "For the dashboard, should it show: A) Just active tasks, B) All tasks with filters, or C) Kanban board view? You mentioned 'tradie management', so I'm suggesting B."
```

**Anti-Pattern: Asking What Was Already Stated**
```
❌ User said "Use Next.js 14 with App Router"
❌ Claude asks "What framework should I use?"
✅ Claude says "I'll use Next.js 14 App Router as specified"
```

---

## 🎯 SUCCESS METRICS

**One-Shot Excellence Criteria:**

✅ Clarification phase completes in <10 minutes
✅ Total question count: 5-10 questions
✅ Zero "you didn't tell me X" during agent execution
✅ First Ralph iteration produces runnable code
✅ User stories are truly atomic (1 iteration each)
✅ Success criteria are objectively verifiable
✅ >80% of user stories complete autonomously

**Quality Checklist Before Execution:**

- [ ] All file paths are absolute and verified to exist
- [ ] All credentials locations are specified
- [ ] All API integrations have auth details
- [ ] All user stories have GIVEN/WHEN/THEN criteria
- [ ] All dependencies between stories are explicit
- [ ] All error handling strategies are defined
- [ ] All success criteria are testable
- [ ] No "TBD" or "TODO" in the PRD
- [ ] No ambiguous terms like "something like X"
- [ ] Scope boundaries are clear (what's IN and OUT)

---

## 🔬 EXAMPLE: FULL WORKFLOW

### Voice Transcript (Abbreviated):

> "The project is called Tradie Lead Prioritizer. This is for AgileAdapt. The whole point is to automatically score and prioritize the 3800 leads in our Zoho CRM database so I can focus on high-value prospects. Success means increasing conversion rate from 2% to 5% within 2 months by targeting the right leads first.
>
> Right now I'm wasting hours manually reviewing leads that go nowhere. What's broken is I can't tell which electrician or plumber is actually ready to buy versus just browsing. The manual process involves opening each lead, reading notes, checking website, and guessing.
>
> What I want to build is a Next.js dashboard that pulls leads from Zoho, runs an AI scoring algorithm based on website quality, business age, and inquiry keywords, and displays them ranked by likelihood to convert.
>
> For tech stack, Next.js 14 with App Router, Tailwind and Shadcn UI. Zoho CRM API for data. Maybe use Claude API for intelligent scoring. Store nothing locally - all live from Zoho.
>
> The credentials are in my .env file at /Users/kinan/agileadapt/.env.local - ZOHO_API_KEY and ANTHROPIC_API_KEY already there.
>
> What happens when Zoho API fails? Should gracefully show error and retry 3 times. Should NOT ever delete or modify leads in Zoho.
>
> I know it's done when I can log in, see my 3800 leads ranked by score, and clicking on one shows me why it got that score. Quality bar is MVP - doesn't need to be pretty, just functional."

### Claude's Clarification (One Question at a Time):

**Q1:** "For the Next.js project, what's the absolute path where this should live? Is it:
- /Users/kinan/agileadapt/apps/tradie-prioritizer (new subfolder)
- /Users/kinan/agileadapt (add to existing app)
- Separate new project location?

You mentioned .env.local at /Users/kinan/agileadapt/, so I'm guessing it's adding to existing AgileAdapt app."

**A1:** "Yes, add to existing at /Users/kinan/agileadapt. Create a new route at /app/tradie-leads/"

**Q2:** "For Zoho CRM API, I need to confirm the endpoint. Are you pulling from:
- /crm/v2/Leads (standard endpoint)
- /crm/v2/Leads/search with custom criteria
- Different module?

I'll default to standard /crm/v2/Leads and fetch all records."

**A2:** "Standard /crm/v2/Leads is fine. Just get all leads."

**Q3:** "For the AI scoring algorithm using Claude API, should I:
A) Send each lead individually (3800 API calls - expensive)
B) Batch leads in groups of 50 and score together (76 calls)
C) Simple rules-based scoring (no Claude API)

Given your budget awareness from past chats, I'd suggest B or start with C for MVP."

**A3:** "Start with C - rules based. We can add Claude later."

**Q4:** "For displaying 'why it got that score', should the scoring algorithm:
A) Just assign 0-100 score with no explanation
B) Store reason tags like ['has-website', 'recent-inquiry', 'commercial']
C) Generate full text explanation

For MVP, I'd suggest B."

**A4:** "B is perfect."

**Q5:** "When user clicks a lead, should it:
A) Show lead details inline on same page
B) Open modal overlay
C) Navigate to dedicated /app/tradie-leads/[id] page

For Next.js App Router best practices, I'd suggest C."

**A5:** "C makes sense."

### Claude's Structured Summary:

"Here's the complete plan for confirmation:

**PROJECT:** Tradie Lead Prioritizer
**LOCATION:** /Users/kinan/agileadapt/app/tradie-leads/
**STACK:** Next.js 14 App Router, Tailwind, Shadcn UI
**DATA:** Live from Zoho CRM API (/crm/v2/Leads), credentials in .env.local
**SCORING:** Rules-based algorithm (no AI initially)
- +20 points if lead has website
- +15 points if inquiry <30 days old  
- +10 points if Commercial keyword in notes
- +10 points if ABN/Business name filled
- +5 points per previous interaction
**UI:** Dashboard with ranked table, click lead → detail page showing score breakdown
**ERROR HANDLING:** Retry Zoho API 3x on fail, show toast error, never write to Zoho

Does this capture it?"

**User confirms.**

### Final Ralph Output:

```markdown
/ralph-loop

### PROJECT: Tradie Lead Prioritizer

### CONTEXT:
AgileAdapt dashboard feature to automatically score and prioritize 3800+ Zoho CRM leads based on conversion likelihood, enabling focus on high-value prospects to increase conversion from 2% to 5%.

### REQUIREMENTS:
* Built with Next.js 14 App Router at /Users/kinan/agileadapt/app/tradie-leads/
* Uses Tailwind CSS and Shadcn UI components
* Fetches all leads from Zoho CRM API v2 (/crm/v2/Leads) using existing ZOHO_API_KEY
* Implements rules-based scoring algorithm (0-100 scale) without external AI
* Displays leads in sortable table ranked by score (highest first)
* Shows score breakdown with reason tags when user clicks lead
* Never writes/modifies data in Zoho CRM (read-only)
* Handles API failures with 3-retry logic and user-facing error messages

### SUCCESS CRITERIA:
* Visiting /tradie-leads shows table of all leads with Name, Business, Score, Last Contact
* Scores calculate correctly: +20 website, +15 recent inquiry, +10 commercial, +10 ABN, +5 per interaction
* Clicking any lead navigates to /tradie-leads/[id] detail page
* Detail page displays score breakdown with highlighted reason tags
* API failure shows error toast and retries 3 times before failing gracefully
* Build command (npm run build) succeeds with zero errors
* No TypeScript errors in /app/tradie-leads/**/*
* README updated with new /tradie-leads route description

### TECHNICAL CONSTRAINTS:
* Stack: Next.js 14.0.0+, React 18+, TypeScript
* File locations: All files under /Users/kinan/agileadapt/app/tradie-leads/
* Credentials: .env.local at /Users/kinan/agileadapt/.env.local (ZOHO_API_KEY exists)
* API: Zoho CRM v2 REST API, auth via API key in header, endpoint: https://www.zohoapis.com.au/crm/v2/Leads
* Performance: Initial load <5sec for 3800 records, table must be client-side sortable
* Security: Read-only API calls, never POST/PUT/DELETE to Zoho

### USER STORIES:

#### Story 1: Setup Tradie Leads Route Structure
**Description:** As a developer, I need a new Next.js route at /tradie-leads so that the feature has a proper home
**Acceptance Criteria:**
- [ ] Directory exists: /Users/kinan/agileadapt/app/tradie-leads/
- [ ] page.tsx created with basic "Tradie Leads" heading
- [ ] layout.tsx created (can inherit from root layout)
- [ ] Navigating to localhost:3000/tradie-leads shows page
**Files:** /app/tradie-leads/page.tsx, /app/tradie-leads/layout.tsx
**Dependencies:** None

#### Story 2: Create Zoho CRM API Client
**Description:** As the app, I need to fetch leads from Zoho CRM so that I have data to display
**Acceptance Criteria:**
- [ ] GIVEN ZOHO_API_KEY in .env.local
- [ ] WHEN fetchLeads() is called
- [ ] THEN it returns array of lead objects with fields: id, Company, Contact_Name, Website, Created_Time, Description, Lead_Status
- [ ] AND API failures retry 3x with exponential backoff
- [ ] AND final failure throws error with user-friendly message
**Files:** /lib/zoho-client.ts
**Dependencies:** Story 1

#### Story 3: Implement Lead Scoring Algorithm
**Description:** As a user, I want leads to have a numeric score so I can prioritize them
**Acceptance Criteria:**
- [ ] GIVEN a lead object from Zoho
- [ ] WHEN calculateScore(lead) is called
- [ ] THEN it returns { score: number, reasons: string[] }
- [ ] AND score calculation follows: +20 if Website exists, +15 if Created_Time <30 days, +10 if Description contains "commercial", +10 if Company filled, +5 per Previous_Interaction count
- [ ] AND reasons array contains human-readable tags like "Has Website", "Recent Inquiry"
**Files:** /lib/scoring-engine.ts
**Dependencies:** Story 2

#### Story 4: Build Lead Dashboard Table
**Description:** As a user, I want to see all leads in a sorted table so I can browse high-priority prospects
**Acceptance Criteria:**
- [ ] GIVEN fetchLeads() returns data
- [ ] WHEN page loads
- [ ] THEN table displays with columns: Name, Company, Score, Last Contact, Actions
- [ ] AND table is sortable by Score (default: highest first)
- [ ] AND table shows loading state while fetching
- [ ] AND table shows error state if API fails after retries
**Files:** /app/tradie-leads/page.tsx, /components/LeadTable.tsx
**Dependencies:** Story 2, Story 3

#### Story 5: Create Lead Detail Page
**Description:** As a user, I want to click a lead and see detailed scoring breakdown so I know why it ranks high/low
**Acceptance Criteria:**
- [ ] GIVEN I'm on /tradie-leads
- [ ] WHEN I click "View Details" on any lead
- [ ] THEN I navigate to /tradie-leads/[leadId]
- [ ] AND detail page shows lead's full name, company, contact info
- [ ] AND score is prominently displayed with reason tags
- [ ] AND each reason tag is visually distinct (badges/chips)
**Files:** /app/tradie-leads/[id]/page.tsx, /components/ScoreBreakdown.tsx
**Dependencies:** Story 3, Story 4

### SAFETY LIMITS:
* Max Iterations: 30
* Timeout per iteration: 10 minutes
* Token budget: ~$30 estimated

### ERROR HANDLING STRATEGY:
* API failures: Retry 3x exponential backoff, then show error toast, log to console
* User-facing errors: Toast notification with actionable message
* Never write to Zoho (read-only guards in API client)
```

---

## 🚀 READY TO USE

This system is optimized for:
- ✅ Wispr Flow 10-minute voice capture
- ✅ Claude's systematic clarification
- ✅ Ralph Wiggum /ralph-loop one-shot execution
- ✅ Genesis Protocol autonomous runs
- ✅ Zero gaps in agent understanding

**Your instinct was correct: The clarification phase IS the critical success factor.**

This system ensures agents have everything they need to execute flawlessly overnight.
